/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent;

import java.net.SocketException;
import java.util.ArrayList;
import net.sourceforge.peers.sip.core.useragent.InitialRequestManager;
import net.sourceforge.peers.sip.core.useragent.MidDialogRequestManager;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transport.SipMessage;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.SipServerTransportUser;
import net.sourceforge.peers.sip.transport.TransportManager;

public class UAS
implements SipServerTransportUser {
    public static final ArrayList<String> SUPPORTED_METHODS = new ArrayList();
    private InitialRequestManager initialRequestManager;
    private MidDialogRequestManager midDialogRequestManager;
    private DialogManager dialogManager;

    public UAS(UserAgent userAgent, InitialRequestManager initialRequestManager, MidDialogRequestManager midDialogRequestManager, DialogManager dialogManager, TransactionManager transactionManager, TransportManager transportManager) throws SocketException {
        this.initialRequestManager = initialRequestManager;
        this.midDialogRequestManager = midDialogRequestManager;
        this.dialogManager = dialogManager;
        transportManager.setSipServerTransportUser(this);
        transportManager.createServerTransport("UDP", userAgent.getConfig().getSipPort());
    }

    @Override
    public void messageReceived(SipMessage sipMessage) {
        if (sipMessage instanceof SipRequest) {
            this.requestReceived((SipRequest)sipMessage);
        } else if (sipMessage instanceof SipResponse) {
            this.responseReceived((SipResponse)sipMessage);
        } else {
            throw new RuntimeException("unknown message type");
        }
    }

    private void responseReceived(SipResponse sipResponse) {
    }

    private void requestReceived(SipRequest sipRequest) {
        SipHeaders headers = sipRequest.getSipHeaders();
        SipHeaderFieldValue to = headers.get(new SipHeaderFieldName("To"));
        String toTag = to.getParam(new SipHeaderParamName("tag"));
        if (toTag != null) {
            Dialog dialog = this.dialogManager.getDialog(sipRequest);
            if (dialog != null) {
                this.midDialogRequestManager.manageMidDialogRequest(sipRequest, dialog);
            }
        } else {
            this.initialRequestManager.manageInitialRequest(sipRequest);
        }
    }

    void acceptCall(SipRequest sipRequest, Dialog dialog) {
        this.initialRequestManager.getInviteHandler().acceptCall(sipRequest, dialog);
    }

    void rejectCall(SipRequest sipRequest) {
        this.initialRequestManager.getInviteHandler().rejectCall(sipRequest);
    }

    public InitialRequestManager getInitialRequestManager() {
        return this.initialRequestManager;
    }

    public MidDialogRequestManager getMidDialogRequestManager() {
        return this.midDialogRequestManager;
    }

    static {
        SUPPORTED_METHODS.add("INVITE");
        SUPPORTED_METHODS.add("ACK");
        SUPPORTED_METHODS.add("CANCEL");
        SUPPORTED_METHODS.add("OPTIONS");
        SUPPORTED_METHODS.add("BYE");
    }
}

